unit frmCadBasico;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ComCtrls, ExtCtrls, StdCtrls, Buttons, ImgList, Grids,
  DBGrids, FMTBcd, Provider, DBClient, DB, SqlExpr;

type
  TStatusBotoes = (stInsercao, stNavegacao);
  TStatusPanels = (stCadastro, stConsulta, stResultSet);

  TfCadBasico = class(TForm)
    pnlBotoes: TPanel;
    pnlPesquisa: TPanel;
    pnlResultSet: TPanel;
    pnlCampos: TPanel;
    StatusBar: TStatusBar;
    MenuPrincipal: TMainMenu;
    Arquivo1: TMenuItem;
    Fechar1: TMenuItem;
    Funes1: TMenuItem;
    NovoRegistro: TMenuItem;
    GravarRegistro: TMenuItem;
    N1: TMenuItem;
    EditarRegistro: TMenuItem;
    ExcluirRegistro: TMenuItem;
    N2: TMenuItem;
    Pesquisar: TMenuItem;
    N3: TMenuItem;
    SobreoSistema1: TMenuItem;
    ImageList: TImageList;
    bbtNovoRegistro: TBitBtn;
    bbtGravarRegistro: TBitBtn;
    bbtEditarRegistro: TBitBtn;
    bbtExcluirRegistro: TBitBtn;
    bbtPesquisar: TBitBtn;
    bbtFechar: TBitBtn;
    pnlResultSetBotoes: TPanel;
    bbtSelecionaRegistro: TBitBtn;
    bbtVoltarPesquisa: TBitBtn;
    dbGrid: TDBGrid;
    pnlPesquisaBotoes: TPanel;
    bbtPesquisarRegistro: TBitBtn;
    bbtVoltarCadastro: TBitBtn;
    qryCadBasico: TSQLQuery;
    dsCadBasico: TDataSource;
    cdsCadBasico: TClientDataSet;
    dspCadBasico: TDataSetProvider;
    procedure bbtNovoRegistroClick(Sender: TObject);
    procedure bbtGravarRegistroClick(Sender: TObject);
    procedure bbtExcluirRegistroClick(Sender: TObject);
    procedure bbtEditarRegistroClick(Sender: TObject);
  private
    { Private declarations }

  protected
    { Protected declarations }
    procedure ConfiguraBotoes(EStatusBotoes: TStatusBotoes);
    procedure ConfiguraPanels(EStatusPanels: TStatusPanels);

    function PersistirDados(): Integer; Virtual; Abstract;
  public
    { Public declarations }

  end;

var
  fCadBasico: TfCadBasico;

implementation

uses uDMConexao;

{$R *.dfm}

{ TfCadBasico }

procedure TfCadBasico.ConfiguraBotoes(EStatusBotoes: TStatusBotoes);
begin
  if EStatusBotoes = stInsercao then
  begin
    // Botoes
    bbtNovoRegistro.Enabled    := False;
    bbtGravarRegistro.Enabled  := True;
    bbtExcluirRegistro.Enabled := True;
    bbtEditarRegistro.Enabled := False;

    // Itens de Menu (Funo)
    NovoRegistro.Enabled    := False;
    GravarRegistro.Enabled  := True;
    ExcluirRegistro.Enabled := True;
    EditarRegistro.Enabled := False;
  end
  else if EStatusBotoes = stNavegacao then
  begin
    // Botoes
    bbtNovoRegistro.Enabled    := True;
    bbtGravarRegistro.Enabled  := False;
    if not cdsCadBasico.IsEmpty then
    begin
      bbtExcluirRegistro.Enabled := True;
      bbtEditarRegistro.Enabled := True;
    end
    else
    begin
      bbtExcluirRegistro.Enabled := False;
      bbtEditarRegistro.Enabled := False;
    end;

    // Itens de Menu (Funo)
    NovoRegistro.Enabled    := True;
    GravarRegistro.Enabled  := False;
    if not cdsCadBasico.IsEmpty then
    begin
      ExcluirRegistro.Enabled := True;
      EditarRegistro.Enabled := True;
    end
    else
    begin
      ExcluirRegistro.Enabled := False;
      EditarRegistro.Enabled := False;
    end;
  end;
end;

procedure TfCadBasico.ConfiguraPanels(EStatusPanels: TStatusPanels);
begin
  if EStatusPanels = stCadastro then
  begin
    pnlCampos.Visible    := True;
    pnlPesquisa.Visible  := False;
    pnlResultSet.Visible := False;

    pnlCampos.BringToFront;
  end
  else if EStatusPanels = stConsulta then
  begin
    pnlPesquisa.Visible  := True;
    pnlCampos.Visible    := False;
    pnlResultSet.Visible := False;

    pnlPesquisa.BringToFront;
  end
  else if EStatusPanels = stResultSet then
  begin
    pnlResultSet.Visible := True;
    pnlPesquisa.Visible  := False;
    pnlCampos.Visible    := False;

    pnlResultSet.BringToFront;
  end;
end;

procedure TfCadBasico.bbtNovoRegistroClick(Sender: TObject);
begin
  ActiveControl := nil;

  try
    if not pnlCampos.Visible then
    begin
      ConfiguraPanels(stCadastro);
    end;

    if not dmConexao.SQLConnection.Connected then
    begin
      Exception.Create('O banco de dados no est conectado!');
    end;

    if not (cdsCadBasico.Active) then
    begin
      Exception.Create('O DataSet no est aberto.');
    end;

    if cdsCadBasico.State = dsEdit then
    begin
      Exception.Create('O registro se encontra em modo de edio.');
    end;

    cdsCadBasico.Append;

    ConfiguraBotoes(stInsercao);
  except
    on E:Exception do
    begin
      ConfiguraBotoes(stNavegacao);
      Raise Exception.Create('Ocorreu um erro inicializar um novo registro.' +#13+ 'Mensagem: ' + E.Message);
    end;
  end;
end;

procedure TfCadBasico.bbtGravarRegistroClick(Sender: TObject);
begin
  ActiveControl := nil;

  try
    if not pnlCampos.Visible then
    begin
      ConfiguraPanels(stCadastro);
    end;

    if not dmConexao.SQLConnection.Connected then
    begin
      Exception.Create('O banco de dados no est conectado!');
    end;

    if not cdsCadBasico.Active then
    begin
      Exception.Create('O DataSet no est aberto.');
    end;

    // Se o registro no estiver em estado de insero ou edio o registro no
    // dever ser salvo.
    if (not (cdsCadBasico.State = dsInsert)) and  (not (cdsCadBasico.State = dsEdit)) then
    begin
      Exception.Create('O registro no se encontra em estado de edio.');
    end;

    if PersistirDados() < 0 then
    begin
      Exit;
    end;

    cdsCadBasico.Post;

    if cdsCadBasico.ApplyUpdates(0) > 0 then
    begin
      Exception.Create('Falha no banco de dados.');
    end;

    ConfiguraBotoes(stNavegacao);
  except
    on E:Exception do
    begin
      Raise Exception.Create('Ocorreu um erro ao gravar os dados no banco de dados.' +#13+ 'Mensagem: ' + E.Message);
    end;
  end;
end;

procedure TfCadBasico.bbtExcluirRegistroClick(Sender: TObject);
begin
  ActiveControl := nil;

  if Application.MessageBox('Deseja excluir o registro selecionado?', 'Confirma excluso', MB_YesNo + MB_ICONQUESTION) = IdNo then
  begin
    Exit;
  end;

  try
    if not pnlCampos.Visible then
    begin
      ConfiguraPanels(stCadastro);
    end;

    if not dmConexao.SQLConnection.Connected then
    begin
      Exception.Create('O banco de dados no est conectado!');
    end;

    if not cdsCadBasico.Active then
    begin
      Exception.Create('O DataSet no est aberto.');
    end;

    if cdsCadBasico.State = dsEdit then
    begin
      cdsCadBasico.Cancel;
    end
    else
    begin
      cdsCadBasico.Delete;

      if cdsCadBasico.ApplyUpdates(0) > 0 then
      begin
        Exception.Create('Falha no banco de dados.');
      end;
    end;

    ConfiguraBotoes(stNavegacao);
  except
    on E:Exception do
    begin
      ConfiguraBotoes(stNavegacao);
      Raise Exception.Create('Ocorreu um erro ao excluir os dados do banco de dados.' +#13+ 'Mensagem: ' + E.Message);
    end;
  end;
end;

procedure TfCadBasico.bbtEditarRegistroClick(Sender: TObject);
begin
  ActiveControl := nil;

  try
    if not pnlCampos.Visible then
    begin
      ConfiguraPanels(stCadastro);
    end;

    if not dmConexao.SQLConnection.Connected then
    begin
      Exception.Create('O banco de dados no est conectado!');
    end;

    if not cdsCadBasico.Active then
    begin
      Exception.Create('O DataSet no est aberto.');
    end;

    // Se o registro estiver em estado de insero ou edio o registro no
    // dever ser colocado em estado de edio.
    if (cdsCadBasico.State = dsInsert) or (cdsCadBasico.State = dsEdit) then
    begin
      Exception.Create('O registro j se encontra em edio.');
    end;

    cdsCadBasico.Edit;
    ConfiguraBotoes(stInsercao);
  except
    on E:Exception do
    begin
      ConfiguraBotoes(stNavegacao);
      Raise Exception.Create('Ocorreu um erro ao tentar editar o registro.' +#13+ 'Mensagem: ' + E.Message);
    end;
  end;
end;

end.
